/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.HashMap;
import java.util.Map;

public enum NPCWeight {
    DEFAULT(1);

    private final int weight;
    private static final Map<String, Integer> keywordWeights;

    private NPCWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public static int getWeightByName(String name) {
        int totalWeight = 0;
        if (name.contains("Crossbow")) {
            totalWeight += 3;
        } else if (name.contains("Uruk")) {
            ++totalWeight;
        }
        if (name.contains("Uruk")) {
            ++totalWeight;
        }
        for (Map.Entry<String, Integer> entry : keywordWeights.entrySet()) {
            String keyword = entry.getKey();
            if (keyword.equals("Crossbow") || keyword.equals("Uruk") || !name.contains(keyword)) continue;
            totalWeight += entry.getValue().intValue();
        }
        return totalWeight > 0 ? totalWeight : DEFAULT.getWeight();
    }

    static {
        keywordWeights = new HashMap<String, Integer>();
        keywordWeights.put("Berserk", 2);
        keywordWeights.put("IronfistBerserk", 2);
        keywordWeights.put("WickedDwarf", 3);
        keywordWeights.put("Warrior", 2);
        keywordWeights.put("Soldier", 2);
        keywordWeights.put("Knight", 2);
        keywordWeights.put("Swan", 1);
        keywordWeights.put("GoldWarrior", 1);
        keywordWeights.put("Champion", 2);
        keywordWeights.put("EreborGuard", 2);
        keywordWeights.put("WargBombardier", 10);
        keywordWeights.put("OrcBombardier", 2);
        keywordWeights.put("Archer", 2);
        keywordWeights.put("AxeThrower", 2);
        keywordWeights.put("Axe", 1);
        keywordWeights.put("Axeman", 1);
        keywordWeights.put("Marine", 2);
        keywordWeights.put("DwarfBerserk", 2);
        keywordWeights.put("Tormented", 3);
        keywordWeights.put("FlameThrower", 3);
        keywordWeights.put("Citadel", 2);
        keywordWeights.put("OlogHai", 6);
        keywordWeights.put("Troll", 3);
        keywordWeights.put("BannerBearer", 3);
        keywordWeights.put("Znam", 4);
        keywordWeights.put("Wight", 3);
        keywordWeights.put("Wraith", 3);
        keywordWeights.put("Fire", 3);
        keywordWeights.put("AngbandBerserker2", 3);
        keywordWeights.put("Ice", 1);
        keywordWeights.put("Spider", 2);
        keywordWeights.put("Blowgunner", 3);
        keywordWeights.put("Warg", 2);
        keywordWeights.put("Obsidian", 2);
        keywordWeights.put("AngmarOrcWarrior", 3);
        keywordWeights.put("Balrog", 10);
        keywordWeights.put("BlackUruk", 1);
        keywordWeights.put("MordorTroll", 1);
        keywordWeights.put("Mountain", 1);
        keywordWeights.put("Cave", 2);
        keywordWeights.put("Tundra", 2);
        keywordWeights.put("DurmethOrc", 2);
        keywordWeights.put("ElfScout", 2);
        keywordWeights.put("Warden", 2);
    }
}

